package com.biz.crm.nebular.sfa;

import com.biz.crm.common.param.RedisParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

/**
 * @author lf
 * @describe
 * @project crm
 * @package com.biz.crm.nebular.sfa
 * @date 2021/6/21 16:36
 */
@Data
public class SfaTpmActDisplayVo implements Serializable {

    /**
     * tpm活动陈列金额/活动金额
     */
    public static final String SFA_TPM_ACT_DISPLAY_OR_TPM_ACT_AMOUNT = "SFA_TPM_ACT_DISPLAY_OR_TPM_ACT_AMOUNT";

    public static final Long REDIS_EXPIRE_TIME = Long.valueOf(60 * 60 * 5);

    @ApiModelProperty("是否签署协议(Y-是,N-否)")
    private String isSignDisplayAgreement;

    @ApiModelProperty("总金额(协议总金额/活动总金额)")
    private BigDecimal totalPrice;

    @ApiModelProperty("可用金额(协议剩余可用金额/活动剩余可用金额)")
    private BigDecimal surplusAmount;

    @ApiModelProperty("是否控制活动费用(Y/N)")
    private String isControlActFee;

    /**
     * 组装redisKey
     *
     * @param actDetailCode
     * @return
     */
    public static String buildRedisHashKey(String actDetailCode) {
        return SFA_TPM_ACT_DISPLAY_OR_TPM_ACT_AMOUNT + RedisParam.DELIMITER + actDetailCode;
    }

    /**
     * 组装redisMap
     *
     * @return
     */
    public Map<String, SfaTpmActDisplayVo> buildRedisMap(String terminalCode) {
        Map<String, SfaTpmActDisplayVo> map = new HashMap<>();
        map.put(terminalCode, this);
        return map;
    }
}
