package com.biz.crm.nebular.sfa.actscheme.resp;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
import java.util.Map;

/**
 * 活动方案;返回vo
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "活动方案;")
@SaturnEntity(name = "SfaActSchemeRespVo", description = "活动方案;")
public class SfaActSchemeRespVo extends CrmExtTenVo {

    @ApiModelProperty("方案名称")
    @SaturnColumn(description = "方案名称")
    private String schemeName;

    @ApiModelProperty("方案编码")
    @SaturnColumn(description = "方案编码")
    private String schemeCode;

    @ApiModelProperty("方案类型(1-陈列方案,2-常规促销,3-特渠促销)")
    @SaturnColumn(description = "方案类型(1-陈列方案,2-常规促销,3-特渠促销)")
    private String schemeType;

    @ApiModelProperty("方案类型描述(1-陈列方案,2-常规促销,3-特渠促销)")
    @SaturnColumn(description = "方案类型描述(1-陈列方案,2-常规促销,3-特渠促销)")
    @CrmDict(typeCode = "scheme_type",dictCodeField = "schemeType")
    private String schemeTypeDesc;

    @ApiModelProperty("方案执行开始时间")
    @SaturnColumn(description = "方案执行开始时间")
    private String schemeStartTime;

    @ApiModelProperty("方案执行开始时间")
    @SaturnColumn(description = "方案执行开始时间")
    private String schemeEndTime;

    @ApiModelProperty("陈列类型")
    @SaturnColumn(description = "陈列类型")
    private String displayType;

    @ApiModelProperty("陈列类型描述")
    @SaturnColumn(description = "陈列类型描述")
    private String displayTypeDesc;

    @ApiModelProperty("陈列类型集合")
    @SaturnColumn(description = "陈列类型集合")
    private List<String> displayTypeList;

    @ApiModelProperty("陈列类型描述集合")
    @SaturnColumn(description = "陈列类型描述集合")
    private List<String> displayTypeDescList;

    @ApiModelProperty("陈列类型Map")
    @SaturnColumn(description = "陈列类型Map")
    private Map<String,String> displayTypeMap;

    @ApiModelProperty("门店类型")
    @SaturnColumn(description = "门店类型")
    private String terminalType;

    @ApiModelProperty("门店类型描述")
    @SaturnColumn(description = "门店类型描述")
    private String terminalTypeDesc;

    @ApiModelProperty("门店类型Map")
    @SaturnColumn(description = "门店类型Map")
    private Map<String,String> terminalTypeMap;

    @ApiModelProperty("门店类型集合")
    @SaturnColumn(description = "门店类型集合")
    private List<String> terminalTypeList;

    @ApiModelProperty("门店类型描述集合")
    @SaturnColumn(description = "门店类型描述集合")
    private List<String> terminalTypeDescList;

    @ApiModelProperty("方案描述")
    @SaturnColumn(description = "方案描述")
    private String schemeDesc;

    @ApiModelProperty("人员账号")
    @SaturnColumn(description = "人员账号")
    private String userName;

    @ApiModelProperty("人员姓名")
    @SaturnColumn(description = "人员姓名")
    private String realName;

    @ApiModelProperty("职位名称")
    @SaturnColumn(description = "职位名称")
    private String posName;

    @ApiModelProperty("职位编码")
    @SaturnColumn(description = "职位编码")
    private String posCode;

    @ApiModelProperty("组织名称")
    @SaturnColumn(description = "组织名称")
    private String orgName;

    @ApiModelProperty("组织编码")
    @SaturnColumn(description = "组织编码")
    private String orgCode;

    @ApiModelProperty("活动方案套餐列表")
    private List<SfaActSchemeSetmealRespVo> actSchemeSetmealList;

    @ApiModelProperty("活动方案文件列表")
    private List<SfaActSchemePictureRespVo> actSchemePictureList;

    @ApiModelProperty("活动方案范围列表")
    private List<SfaActSchemeRangeRespVo> actSchemeRangeList;

    @ApiModelProperty("已申请该方案的活动信息")
    private List<SfaActSchemePosApplyRespVo> actSchemePosApplyList;

    @ApiModelProperty("兑付方式集合")
    @SaturnColumn(description = "兑付方式集合")
    private Map<String, String> paymentMethodMap;

}