package com.biz.crm.nebular.sfa.acttask.req;

import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;
/**
 * 活动任务管理 请求vo
 *
 * @author liuhongming
 * @date 2020-09-23 11:24:25
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaActTaskReqVo", description = "活动任务管理 ")
public class SfaActTaskReqVo extends CrmExtVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("活动编码 活动编码")
    private String actCode;

    @ApiModelProperty("活动名称 活动名称")
    private String actName;

    @ApiModelProperty("活动类型 活动类型(display:陈列活动，cost:费用活动)")
    private String actType;

    @ApiModelProperty("活动开始时间 活动开始时间")
    private String beginDate;

    @ApiModelProperty("活动结束时间 活动结束时间")
    private String endDate;

    @ApiModelProperty("活动描述 活动描述")
    private String actDesc;

    @ApiModelProperty("预估销售额 费用活动-预估销售额")
    private BigDecimal forecastSalesAmount;

    @ApiModelProperty("费用申请金额 费用活动-费用申请金额")
    private BigDecimal applyAmount;

    @ApiModelProperty("活动要求 活动要求")
    private String actRequire;

    @ApiModelProperty("任务执行频率 陈列活动-任务执行频率")
    private BigDecimal actFrequency;

    @ApiModelProperty("活动编码集合 活动编码集合")
    private List<String> actCodes;

    @ApiModelProperty("活动范围 活动范围包含")
    private List<SfaActRangeReqVo> sfaActRangeReqContainVos;
    @ApiModelProperty("活动范围 活动范围不包含")
    private List<SfaActRangeReqVo> sfaActRangeReqNotContainVos;
    @ApiModelProperty("陈列要求 陈列活动-陈列要求")
    private List<SfaActProductReqVo> sfaActProductReqVos;
    @ApiModelProperty("示例图片 陈列活动-活动附件示例图片")
    private List<SfaActFileReqVo> sfaActFileReqVos;

}