package com.biz.crm.nebular.sfa.asexecution.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * 方案活动终止;请求vo
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaAsStopReqVo", description = "方案活动终止;")
public class SfaAsStopReqVo extends CrmExtTenVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("活动编码")
    private String activityCode;

    @ApiModelProperty("终端编码")
    private String terminalCode;

    @ApiModelProperty("终端名称")
    private String terminalName;

    @ApiModelProperty("终结状态(0:未终止;1:终止)")
    private String stopState;

    @ApiModelProperty("终止时间")
    private String stopDate;

    @ApiModelProperty("人员账号")
    private String userName;

    @ApiModelProperty("人员姓名")
    private String realName;

    @ApiModelProperty("职位名称")
    private String posName;

    @ApiModelProperty("职位编码")
    private String posCode;

    @ApiModelProperty("组织名称")
    private String orgName;

    @ApiModelProperty("组织编码")
    private String orgCode;

}