package com.biz.crm.nebular.sfa.clientsellpower.req;

import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
/**
 * 经销商/终端产品经销权 请求vo
 *
 * @author liuhongming
 * @date 2020-09-24 14:13:28
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaClientSellPowerReqVo", description = "经销商/终端产品经销权 ")
public class SfaClientSellPowerReqVo extends CrmExtVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("经销权编码 经销权编码")
    private String tspCode;

    @ApiModelProperty("客户类型 客户类型(01:经销商;02:终端;)")
    private String clientType;

    @ApiModelProperty("经销商/终端产品经销权可购商品")
    private List<SfaClientSellProductReqVo> sfaClientSellProductReqVos;

    @ApiModelProperty("经销商/终端产品经销权范围")
    private List<SfaClientSellRangeReqVo> sfaClientSellRangeReqVos;

    @ApiModelProperty("经销权编码集合")
    private List<String> tspCodes;

}