package com.biz.crm.nebular.sfa.freesignconfig.resp;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;

/**
 * 签到组-打卡人员 返回vo
 *
 * @author liuhongming
 * @date 2020-09-17 14:40:27
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "签到组-打卡人员 ")
@SaturnEntity(name = "SfaFreesignPersonnelRespVo", description = "签到组-打卡人员 ")
public class SfaFreesignPersonnelRespVo extends CrmBaseVo {
    @ApiModelProperty("编码 编码")
    @SaturnColumn(description = "编码 编码")
    private String personnelCode;

    @ApiModelProperty("名称 名称")
    @SaturnColumn(description = "名称 名称")
    private String personnelName;

    @ApiModelProperty("组织范围 组织范围(10:当前组织;20:当前组织及下级组织)")
    @SaturnColumn(description = "组织范围 组织范围(10:当前组织;20:当前组织及下级组织)")
    private String orgRange;

    @ApiModelProperty("类型 类型(1:组织类型;2:组织;3:人员)")
    @SaturnColumn(description = "类型 类型(1:组织类型;2:组织;3:人员)")
    private String personnelType;

    @ApiModelProperty("范围类型 范围类型(1:包含;2:非包含;)")
    @SaturnColumn(description = "范围类型 范围类型(1:包含;2:非包含;)")
    private String rangeType;

    @ApiModelProperty("签到组编码 签到组编码")
    @SaturnColumn(description = "签到组编码 签到组编码")
    private String freesignCode;

    private String ext1 = StringUtils.EMPTY;

    private String ext2 = StringUtils.EMPTY;

    private String ext3 = StringUtils.EMPTY;

    private String ext4 = StringUtils.EMPTY;

    private String ext5 = StringUtils.EMPTY;

    private String ext6 = StringUtils.EMPTY;

    private String ext7 = StringUtils.EMPTY;

    private String ext8 = StringUtils.EMPTY;

    private String ext9 = StringUtils.EMPTY;

    private String ext10 = StringUtils.EMPTY;

}