package com.biz.crm.nebular.sfa.helpdefense.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.sfa.picture.req.SfaVisitPictureReqVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "HelpDefenseInStoreReqVo", description = "拜访-协防执行-进店打卡请求对象;")
public class HelpDefenseInStoreReqVo extends CrmExtTenVo {
    @ApiModelProperty("进店地址")
    private String inStoreAddress;

    @ApiModelProperty("进店地址经度;进店地址协访客户经度")
    private BigDecimal inStoreLongitude;

    @ApiModelProperty("进店地址纬度;进店地址协访客户纬度")
    private BigDecimal inStoreLatitude;

    @ApiModelProperty("照片列表")
    private List<SfaVisitPictureReqVo> helpDefensePicList;


}