package com.biz.crm.nebular.sfa.helpdefense.resp;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 拜访-协防执行步骤详情;返回vo
 *
 * @author lf
 * @date 2021-01-11 15:42:32
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "拜访-协防执行步骤详情;")
@SaturnEntity(name = "SfaVisitHelpDefenseDetailRespVo", description = "拜访-协防执行步骤详情;")
public class SfaVisitHelpDefenseDetailRespVo extends CrmExtTenVo {
    @ApiModelProperty("拜访-协防执行id")
    @SaturnColumn(description = "拜访-协防执行id")
    private String visitHelpDefenseId;

    @ApiModelProperty("步骤编码")
    @SaturnColumn(description = "步骤编码")
    private String directoryCode;

    @ApiModelProperty("步骤名称")
    @SaturnColumn(description = "步骤名称")
    private String directoryName;

    @ApiModelProperty("是否合格(0-否,1-是)")
    @SaturnColumn(description = "是否合格(0-否,1-是)")
    private String isQualified;

    @ApiModelProperty("是否合格(0-否,1-是)")
    @CrmDict(typeCode = "",dictCodeField = "is_qualified")
    private String isQualifiedDesc;

}