package com.biz.crm.nebular.sfa.moblie.resp;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.Map;

/**
 * 附近客户 响应vo
 *
 * @author yangshan
 * @date 2021/3/9 15:10
 */

@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaNearbyCustomerRespVo", description = "附近客户")
public class SfaNearbyCustomerRespVo extends CrmBaseVo {

    /**
     * 经度
     */
    @ApiModelProperty("经度")
    private String longitude;

    /**
     * 纬度
     */
    @ApiModelProperty("纬度")
    private String latitude;

    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    private String name;

    /**
     * 地址
     */
    @ApiModelProperty("地址")
    private String address;

    /**
     * 电话
     */
    @ApiModelProperty("电话")
    private String tel;

    /**
     * 距离
     */
    @ApiModelProperty("距离")
    private String distance;

    @ApiModelProperty("按钮名称(1导航 2电话 3异常 4拜访 5详情 6 新增)")
    private Map<String,String> buttons;

}
