package com.biz.crm.nebular.sfa.notice.resp;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 公告附件 返回vo
 *
 * @author liuhongming
 * @date 2020-09-17 17:14:43
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "公告附件 ")
@SaturnEntity(name = "SfaNoticeFileRespVo", description = "公告附件 ")
public class SfaNoticeFileRespVo extends CrmExtVo {
    @ApiModelProperty("附件名称 附件名称")
    @SaturnColumn(description = "附件名称 附件名称")
    private String fileName;

    @ApiModelProperty("附件url路径 url地址")
    @SaturnColumn(description = "附件url路径 url地址")
    private String urlPath;

    @ApiModelProperty("附件物理路径 附件物理路径")
    @SaturnColumn(description = "附件物理路径 附件物理路径")
    private String realPath;

    @ApiModelProperty("公告编码 公告编码")
    @SaturnColumn(description = "公告编码 公告编码")
    private String noticeCode;

    @ApiModelProperty("文件访问路经")
    @SaturnColumn(description = "文件访问路经")
    private String filePath;

    @ApiModelProperty("公告编码集合")
    @SaturnColumn(description = "公告编码集合")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<String> noticeCodes;

    @ApiModelProperty("文件后缀")
    private String fileSuffix;

}