package com.biz.crm.nebular.sfa.tpmact.displaytreaty;

import com.biz.crm.nebular.sfa.tpmact.VisitBaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author lf
 * @describe
 * @project crm
 * @package com.biz.crm.nebular.sfa.tpmact.displaytreaty
 * @date 2021/6/12 17:29
 */
@Data
@ApiModel(value = "cashTreatyVo",description = "现金协议")
public class CashTreatyVo extends DisplayTreatyVo implements Serializable, VisitBaseVo.StepExecuteDataReq {

    /**
     * 每月支付现金
     */
    @ApiModelProperty("每月支付现金")
    private BigDecimal monthPayAmount;

    /**
     * 合计奖励现金
     */
    @ApiModelProperty("合计奖励现金")
    private BigDecimal totalAmount;

    /**
     * 奖励收款人
     */
    @ApiModelProperty("奖励收款人")
    private String payee;

    /**
     * 联系电话
     */
    @ApiModelProperty("联系电话")
    private String contactPhone;
}
