package com.biz.crm.nebular.sfa.visitdealer.resp;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.sfa.collection.resp.SfaVisitRoleDirectoryRespVo;
import com.biz.crm.nebular.sfa.collection.resp.StepInfoVo;
import com.biz.crm.nebular.sfa.picture.resp.SfaVisitPictureRespVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 经销商拜访明细;返回vo
 *
 * @author lf
 * @date 2020-11-17 11:22:50
 */
@Data
@ApiModel(value = "经销商拜访明细;")
public class SfaVisitDealerDetailRespVo extends StepInfoVo {
    @ApiModelProperty("拜访计划编码;")
    private String visitPlanCode;

    @ApiModelProperty("拜访主键id")
    private String visitPlanId;

    @ApiModelProperty("人员账号;")
    private String visitUserName;

    @ApiModelProperty("人员姓名;")
    private String visitRealName;

    @ApiModelProperty("人员职位编码;")
    private String visitPosCode;

    @ApiModelProperty("人员职位名称;")
    private String visitPosName;

    @ApiModelProperty("人员所属组织编码;")
    private String visitOrgCode;

    @ApiModelProperty("人员所属组织名称;")
    private String visitOrgName;

    @ApiModelProperty("人员上级所属组织编码;")
    private String visitParentOrgCode;

    @ApiModelProperty("人员上级所属组织名称;")
    private String visitParentOrgName;

    @ApiModelProperty("拜访日期;拜访日期yyyy-MM-dd")
    private String visitDate;

    @ApiModelProperty("拜访类型;拜访类型(临时拜访/计划拜访)")
    private String visitType;

    @ApiModelProperty("拜访类型;拜访类型(临时拜访/计划拜访)")
    @CrmDict(typeCode = "visitType",dictCodeField = "visitType")
    private String visitTypeDesc;

    @ApiModelProperty("客户id;客户id")
    private String clientId;

    @ApiModelProperty("客户编码;")
    private String clientCode;

    @ApiModelProperty("客户名称;")
    private String clientName;

    @ApiModelProperty("客户类型;")
    private String clientType;

    @ApiModelProperty("客户类型;")
    @CrmDict(typeCode = "sfacusType",dictCodeField = "clientType")
    private String clientTypeDesc;

    @ApiModelProperty("客户电话 客户电话")
    private String clientPhone;

    @ApiModelProperty("客户头像")
    private String clientPhoto;

    @ApiModelProperty("客户地址;客户地址")
    private String clientAddress;

    @ApiModelProperty("状态;拜访状态")
    private String visitStatus;

    @ApiModelProperty("异常提交时间")
    private String exceptionTime;

    @ApiModelProperty("异常描述")
    private String exceptionDetail;

    @ApiModelProperty("拜访总结")
    private String visitSummary;

    @ApiModelProperty("上次拜访总结")
    private String lastVisitSummary;

    @ApiModelProperty("进店时间")
    private String inStore;

    @ApiModelProperty("进店地址")
    private String inStoreAddress;

    @ApiModelProperty("进店经度")
    private BigDecimal inStoreLongitude;

    @ApiModelProperty("进店纬度")
    private BigDecimal inStoreLatitude;

    @ApiModelProperty("离店时间")
    private String outStore;

    @ApiModelProperty("离店地址")
    private String outStoreAddress;

    @ApiModelProperty("离店经度")
    private BigDecimal outStoreLongitude;

    @ApiModelProperty("离店纬度")
    private BigDecimal outStoreLatitude;

    @ApiModelProperty("网点经度")
    private String clientLongitude;

    @ApiModelProperty("网点纬度")
    private String clientLatitude;

    @ApiModelProperty("打卡照片")
    private List<SfaVisitPictureRespVo> photoList;

    @ApiModelProperty("进店打开图片列表")
    private List<String> inStorePicList;

    @ApiModelProperty("离店打卡图片列表")
    private List<String> outStorePicList;

    @ApiModelProperty("拜访步骤列表")
    private List<SfaVisitRoleDirectoryRespVo> roleDirectoryRespVos;

    @ApiModelProperty("拜访步骤汇总")
    private Map<String,String> visitDetailStep;
}