package com.biz.crm.nebular.sfa.visitnote.resp;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * 拜访计划制定范围表 返回vo
 *
 * @author liuhongming
 * @date 2020-09-21 14:35:05
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "拜访计划制定范围表 ")
@SaturnEntity(name = "SfaVisitPlanRangeRespVo", description = "拜访计划制定范围表 ")
public class SfaVisitPlanRangeRespVo extends CrmExtVo {
    @ApiModelProperty("线路组id 线路组id")
    @SaturnColumn(description = "线路组id 线路组id")
    private String visitGroupId;

    @ApiModelProperty("线路组名称 线路组名称")
    @SaturnColumn(description = "线路组名称 线路组名称")
    private String visitGroupName;

    @ApiModelProperty("线路组终端数量 线路组终端数量")
    @SaturnColumn(description = "线路组终端数量 线路组终端数量")
    private Integer clientRelNum;

    @ApiModelProperty("网点id 网点id")
    @SaturnColumn(description = "网点id 网点id")
    private String clientId;

    @ApiModelProperty("网点编码 网点编码")
    @SaturnColumn(description = "网点编码 网点编码")
    private String clientCode;

    @ApiModelProperty("网点名称 网点名称")
    @SaturnColumn(description = "网点名称 网点名称")
    private String clientName;

    @ApiModelProperty("网点类型 网点类型")
    @SaturnColumn(description = "网点类型 网点类型")
    private String clientType;

    @ApiModelProperty("网点类型描述 网点类型描述")
    @CrmDict(typeCode = "sfacusType",dictCodeField = "clientType")
    private String clientTypeName;
    @ApiModelProperty("客户细类")
    private String clientSubclass;

    @ApiModelProperty("客户细类")
    private String clientSubclassName;
    @ApiModelProperty("网点地址 网点地址")
    @SaturnColumn(description = "网点地址 网点地址")
    private String clientAddress;

    @ApiModelProperty("网点联系人手机号 网点联系人手机号")
    @SaturnColumn(description = "网点联系人手机号 网点联系人手机号")
    private String clientPhone;

    @ApiModelProperty("网点图片")
    @SaturnColumn(description = "网点图片 网点图片")
    private String clientPhoto;

    @ApiModelProperty("网点联系人")
    @SaturnColumn(description = "网点联系人")
    private String clientContacts;

    @ApiModelProperty("经度;经度")
    @SaturnColumn(description = "经度;经度")
    private BigDecimal longitude;

    @ApiModelProperty("纬度;纬度")
    @SaturnColumn(description = "纬度;纬度")
    private BigDecimal latitude;

    @ApiModelProperty("首次拜访日期 首次拜访日期(yyyy-MM-dd)")
    @SaturnColumn(description = "首次拜访日期 首次拜访日期(yyyy-MM-dd)")
    private String firstVisitDate;

    @ApiModelProperty("拜访频率 拜访频率（天/1次）")
    @SaturnColumn(description = "拜访频率 拜访频率（天/1次）")
    private Integer visitFrequency;

    @ApiModelProperty("拜访计划编码 拜访计划编码")
    @SaturnColumn(description = "拜访计划编码 拜访计划编码")
    private String visitPlanCode;

    @ApiModelProperty("拜访计划制定编码集合")
    @SaturnColumn(description = "拜访计划制定编码集合")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<String> visitPlanCodes;

}