package com.biz.crm.nebular.sfa.visitstep.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
/**
 * 活动执行;请求vo
 *
 * @author lf
 * @date 2020-12-30 19:45:12
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaVisitStepActivityExecutionReqVo", description = "活动执行;")
public class SfaVisitStepActivityExecutionReqVo extends CrmExtTenVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("拜访id")
    private String visitId;

    @ApiModelProperty("活动执行类型(0-费用活动,1-陈列活动,2-tpm活动)")
    private String activityType;

    @ApiModelProperty("活动执行id")
    private String activityExecutionId;

    @ApiModelProperty("网点id")
    private String clientId;

    @ApiModelProperty("网点编码")
    private String clientCode;

    @ApiModelProperty("网点名称")
    private String clientName;

    @ApiModelProperty("客户类型(dealer-经销商,terminal-终端,batchDealer-二批商)")
    private String clientType;

    @ApiModelProperty("活动执行时间")
    private String activityTime;

    @ApiModelProperty("活动执行参数json")
    private String activityJson;

    @ApiModelProperty("人员账号")
    private String userName;

    @ApiModelProperty("人员姓名")
    private String realName;

    @ApiModelProperty("职位名称")
    private String posName;

    @ApiModelProperty("职位编码")
    private String posCode;

    @ApiModelProperty("组织名称")
    private String orgName;

    @ApiModelProperty("组织编码")
    private String orgCode;

    @ApiModelProperty("活动执行地址")
    private String activityExecutionAddress;

    @ApiModelProperty("经度")
    private String longitude;

    @ApiModelProperty("维度")
    private String latitude;

    @ApiModelProperty("活动名称")
    private String activityName;

    @ApiModelProperty("活动执行开始时间")
    private String activityStartTime;

    @ApiModelProperty("活动执行结束时间")
    private String activityEndTime;

    @ApiModelProperty("活动频率(天/次)")
    private String activityFrequency;

    @ApiModelProperty("是否为拜访步骤活动执行")
    private Integer isVisit;

    @ApiModelProperty("活动执行开始时间-开始")
    private String startActivityStartTime;

    @ApiModelProperty("活动执行开始时间-结束")
    private String endActivityStartTime;

    @ApiModelProperty("活动执行结束时间-开始")
    private String startActivityEndTime;

    @ApiModelProperty("活动执行结束时间-结束")
    private String endActivityEndTime;

    @ApiModelProperty("开始活动执行时间")
    private String startActivityTime;

    @ApiModelProperty("结束活动执行时间")
    private String endActivityTime;

    @ApiModelProperty("拍照类型数据列表")
    private List<SfaVisitStepActivityExecutionTypeReqVo> stepActivityExecutionTypeList;

    @ApiModelProperty("编码集合")
    private List<String> codeList;

    @ApiModelProperty("当前时间")
    private String now;

    @ApiModelProperty("是否去重")
    private String doNot;

    @ApiModelProperty("终端类型")
    private String terminalType;

    @ApiModelProperty("流程审批状态")
    private String bpmState;

    @ApiModelProperty("方案活动结案状态  0:未结案；1：结案")
    public String endCaseState;

    @ApiModelProperty("职位编码集合")
    private List<String> posCodeList;

}