package com.biz.crm.nebular.sfa.visitstep.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;
/**
 * 拜访步骤(竞品采集明细) 请求vo
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaVisitStepColletItemReqVo", description = "拜访步骤(竞品采集明细) ")
public class SfaVisitStepColletItemReqVo extends CrmExtTenVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("竞品主表id")
    private String colletId;

    @ApiModelProperty("竞品品牌")
    private String brand;

    @ApiModelProperty("竞品系列")
    private String series;

    @ApiModelProperty("竞品产品编码")
    private String productCode;

    @ApiModelProperty("竞品产品名称")
    private String productName;

    @ApiModelProperty("铺货数量")
    private BigDecimal quantity;

    @ApiModelProperty("单位")
    private String unit;

    @ApiModelProperty("")
    private String untitled;

}