package com.biz.crm.nebular.sfa.visitstepdetail.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
/**
 * 拜访步骤(库存盘点明细);请求vo
 *
 * @author lf
 * @date 2021-01-12 22:41:49
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaVisitStepStockDetailReqVo", description = "拜访步骤(库存盘点明细);")
public class SfaVisitStepStockDetailReqVo extends CrmExtTenVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("库存盘点id")
    private String stockInventoryId;

    @ApiModelProperty("产品编码")
    private String productCode;

    @ApiModelProperty("产品名称")
    private String productName;

    @ApiModelProperty("系列编码")
    private String seriesCode;

    @ApiModelProperty("系列名称")
    private String seriesName;

    @ApiModelProperty("盘库时间")
    private String stockTime;

    @ApiModelProperty("数量")
    private Integer quantity;

    @ApiModelProperty("单位")
    private String unit;
    /**
     * 单位名称
     */
    @ApiModelProperty("单位名称")
    private String unitName;

}