package com.biz.crm.nebular.sfa.worksign.form.req;

import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 增加考勤记录
 * 根据人员账号、职位、组织、打卡日期获取相关考勤信息 搜索条件Vo
 * @author YuanZiJian
 * @date 2021/2/25 13:57
 * @version: V1.0
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "增加考勤记录——搜索条件Vo")
@SaturnEntity(name = "SfaSignAddRecordSearchReqVo", description = "增加考勤记录——搜索条件Vo")
public class SfaSignAddRecordSearchReqVo {
    @ApiModelProperty("人员职位")
    private String posCode;
    @ApiModelProperty("所属组织")
    private String orgCode;
    @ApiModelProperty("人员账号")
    private String userName;
    @ApiModelProperty("打卡时间")
    private String ruleDate;
}
