package com.biz.crm.nebular.sfa.worksign.form.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AccessLevel;
import lombok.Data;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * @author ren.gang
 * @ClassName SfaMonthSignRespVo.java
 * @Description 月度考勤报表返回Vo
 * @createTime 2020年11月30日 13:58:00
 */
@Data
@ApiModel("月度考勤报表返回Vo")
public class SfaMonthSignRespVo {

    @ApiModelProperty("年")
    private String year;

    @ApiModelProperty("月")
    private String month;

    @ApiModelProperty("区域")
    private String parentOrgName;

    @ApiModelProperty("办事处")
    private String orgName;

    @ApiModelProperty("组织编码")
    private String orgCode;

    @ApiModelProperty("人员账号")
    private String userName;

    @ApiModelProperty("人员名称")
    private String realName;

    @ApiModelProperty("职位名称")
    private String posName;

    @ApiModelProperty("职位编码")
    private String posCode;

    @ApiModelProperty("当月几号")
    private String nowDay;

    @ApiModelProperty("需要上班天数")
    private BigDecimal goToWorkDays =  BigDecimal.ZERO;
    public void addGoToWorkDaysl(BigDecimal num) {
        this.goToWorkDays = goToWorkDays.add(num);
    }

    @ApiModelProperty("正常出勤")
    private BigDecimal normal =  BigDecimal.ZERO;
    // 累加正常出勤
    public void addNormal(BigDecimal num) {
        this.normal = normal.add(num);
    }

//    @ApiModelProperty("在勤")
//    private Integer weekDays = 0;
//    // 累加在勤
//    public void addWeekDays(int num){
//        weekDays += num;
//    }

    @ApiModelProperty("休息")
    private BigDecimal offDays =  BigDecimal.ZERO;
    // 累加休息
    public void addOffDays(BigDecimal num) {
        offDays = offDays.add(num);
    }


    @ApiModelProperty("加班")
    private BigDecimal overtimeDays = new BigDecimal(0);
    // 累加加班
    public void addOvertimeDays(BigDecimal num) {
        overtimeDays = overtimeDays.add(num);
    }

    @ApiModelProperty("请假")
    private BigDecimal leaveDays = new BigDecimal(0);
    // 累加请假
    public void addLeaveDays(BigDecimal num) {
        leaveDays = leaveDays.add(num);
    }

    @ApiModelProperty("迟到")
    private Integer lateDays = 0;
    // 累加迟到
    public void addLateDays(int num) {
        lateDays += num;
    }

    @ApiModelProperty("早退")
    private Integer earlyDays = 0;
    // 累加早退
    public void addEarlyDays(int num) {
        earlyDays += num;
    }

    @ApiModelProperty("旷工")
    private BigDecimal absenteeismDays = new BigDecimal(0);
    // 累加旷工
    public void addAbsenteeismDays(BigDecimal num) {
        absenteeismDays = absenteeismDays.add(num);
    }

    @ApiModelProperty("总时长")
    private BigDecimal allTimes =  BigDecimal.ZERO;
    // 累加时长
    public void addAllTimes(BigDecimal num) {
        allTimes = allTimes.add(num);
    }

    @ApiModelProperty("出差天数")
    public Integer  travelDays = 0;

    @ApiModelProperty("完成日报天数")
    public Integer dailyDays = 0;

    @ApiModelProperty("未完成日报天数")
    public Integer notDailyDays = 0;

    public static final String DAY_STATIC = "day";
    public static final String DAY_TIME = "Time";

    @ApiModelProperty("1号")
    
    private String day1;

    @ApiModelProperty("2号") 
    
    private String day2;

    @ApiModelProperty("3号") 
    
    private String day3;

    @ApiModelProperty("4号")
    
    private String day4;

    @ApiModelProperty("5号") 
    
    private String day5;

    @ApiModelProperty("6号") 
    
    private String day6;

    @ApiModelProperty("7号") 
    
    private String day7;

    @ApiModelProperty("8号") 
    
    private String day8;

    @ApiModelProperty("9号") 
    
    private String day9;

    @ApiModelProperty("10号") 
    
    private String day10;

    @ApiModelProperty("11号") 
    
    private String day11;

    @ApiModelProperty("12号") 
    
    private String day12;

    @ApiModelProperty("13号") 
    
    private String day13;

    @ApiModelProperty("14号")
    
    private String day14;

    @ApiModelProperty("15号") 
    
    private String day15;

    @ApiModelProperty("16号") 
    
    private String day16;

    @ApiModelProperty("17号") 
    
    private String day17;

    @ApiModelProperty("18号") 
    
    private String day18;

    @ApiModelProperty("19号") 
    
    private String day19;

    @ApiModelProperty("20号") 
    
    private String day20;

    @ApiModelProperty("21号")
    
    private String day21;

    @ApiModelProperty("22号") 
    
    private String day22;

    @ApiModelProperty("23号") 
    
    private String day23;

    @ApiModelProperty("24号") 
    
    private String day24;

    @ApiModelProperty("25号") 
    
    private String day25;

    @ApiModelProperty("26号") 
    
    private String day26;

    @ApiModelProperty("27号") 
    
    private String day27;

    @ApiModelProperty("28号") 
    
    private String day28;

    @ApiModelProperty("29号") 
    
    private String day29;

    @ApiModelProperty("30号") 
    
    private String day30;

    @ApiModelProperty("31号") 
    
    private String day31;

    @ApiModelProperty("1号工作时长") 
    private String dayTime1 ;

    @ApiModelProperty("2号工作时长") 
    private String dayTime2 ;

    @ApiModelProperty("3号工作时长") 
    private String dayTime3 ;

    @ApiModelProperty("4号工作时长") 
    private String dayTime4 ;

    @ApiModelProperty("5号工作时长") 
    private String dayTime5 ;

    @ApiModelProperty("6号工作时长") 
    private String dayTime6 ;

    @ApiModelProperty("7号工作时长") 
    private String dayTime7 ;

    @ApiModelProperty("8号工作时长") 
    private String dayTime8 ;

    @ApiModelProperty("9号工作时长") 
    private String dayTime9 ;

    @ApiModelProperty("10号工作时长") 
    private String dayTime10 ;

    @ApiModelProperty("11号工作时长") 
    private String dayTime11 ;

    @ApiModelProperty("12号工作时长") 
    private String dayTime12 ;

    @ApiModelProperty("13号工作时长") 
    private String dayTime13 ;

    @ApiModelProperty("14号工作时长") 
    private String dayTime14 ;

    @ApiModelProperty("15号工作时长") 
    private String dayTime15 ;

    @ApiModelProperty("16号工作时长") 
    private String dayTime16 ;

    @ApiModelProperty("17号工作时长") 
    private String dayTime17 ;

    @ApiModelProperty("18号工作时长") 
    private String dayTime18 ;

    @ApiModelProperty("19号工作时长") 
    private String dayTime19 ;

    @ApiModelProperty("20号工作时长") 
    private String dayTime20 ;

    @ApiModelProperty("21号工作时长") 
    private String dayTime21 ;

    @ApiModelProperty("22号工作时长") 
    private String dayTime22 ;

    @ApiModelProperty("23号工作时长") 
    private String dayTime23 ;

    @ApiModelProperty("24号工作时长") 
    private String dayTime24 ;

    @ApiModelProperty("25号工作时长") 
    private String dayTime25 ;

    @ApiModelProperty("26号工作时长") 
    private String dayTime26 ;

    @ApiModelProperty("27号工作时长") 
    private String dayTime27 ;

    @ApiModelProperty("28号工作时长") 
    private String dayTime28 ;

    @ApiModelProperty("29号工作时长") 
    private String dayTime29 ;

    @ApiModelProperty("30号工作时长") 
    private String dayTime30 ;

    @ApiModelProperty("31号工作时长") 
    private String dayTime31 ;

   
}
