package com.biz.crm.nebular.sfa.worksign.form.resp;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.sfa.worksign.resp.SfaAddSignTypeRespVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 增加考勤记录
 * 根据人员账号、职位、组织、打卡日期获取相关考勤信息-返回Vo
 * @author YuanZiJian
 * @date 2021/2/25 14:05
 * @version: V1.0
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "相关考勤信息——返回Vo")
@SaturnEntity(name = "SfaSignAddRecordSearchRespVo", description = "相关考勤信息——返回Vo")
public class SfaSignAddRecordInfoRespVo {
    @ApiModelProperty("规则编码")
    private String ruleCode;
    @ApiModelProperty("规则名称")
    private String ruleName;
    @ApiModelProperty("规则类型")
    private String ruleType;
    @ApiModelProperty("规则类型名称")
    private String ruleTypeName;
    @ApiModelProperty("打卡类型——（该时间的存在相关打卡记录）")
    private List<SfaAddSignTypeRespVo> sfaAddSignTypeRespVoList ;
}
