package com.biz.crm.nebular.sfa.worksign.resp;

import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @author ren.gang
 * @ClassName SfaCopyTaskRespVo.java
 * @Description 抄送给我的返回vo
 * @createTime 2020年12月24日 11:27:00
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "抄送给我的返回vo")
@SaturnEntity(name = "SfaCopyTaskRespVo", description = "抄送给我的返回vo")
public class SfaCopyTaskRespVo {

    @ApiModelProperty(value = "业务id")
    private String id;

    @ApiModelProperty("申请人姓名")
    private String realName;

    @ApiModelProperty("申请人职位名称")
    private String posName;

    @ApiModelProperty("申请人组织名称")
    private String orgName;

    @ApiModelProperty("申请时间")
    private String applicationDate;

    @ApiModelProperty("业务开始时间")
    private String beginTime;

    @ApiModelProperty("业务结束时间")
    private String endTime;

    @ApiModelProperty("业务审批状态")
    private String bpmStatus;

    @ApiModelProperty("业务审批状态名称")
    private String bpmStatusName;

    /**
     * 抄送属性 ↓
     */
    @ApiModelProperty(value = "抄送节点ID")
    private String copyTaskId;

    @ApiModelProperty(value = "流程表单编号")
    private String auditTaskId;

    @ApiModelProperty(value = "流程标题")
    private String title;

    @ApiModelProperty("业务类型")
    private String costType;

    @ApiModelProperty("业务类型名称")
    private String costTypeName;

    @ApiModelProperty(value = "抄送节点状态(1=未读2=已阅)")
    private Integer status;
}
