package com.biz.crm.nebular.sfa.worksign.resp;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 考勤明细报表 请求vo
 *
 * @author liuhongming
 * @date 2020-10-14 15:05:08
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaWorkSignInfoRespVo", description = "考勤明细报表 ")
public class SfaWorkSignInfoRespVo extends CrmExtVo {

    @ApiModelProperty("考勤规则明细表id 考勤规则明细表id")
    @SaturnColumn(description = "考勤规则明细表id 考勤规则明细表id")
    private String wsRuleInfoId;

    @ApiModelProperty("考勤打卡记录表id 考勤打卡记录表id")
    @SaturnColumn(description = "考勤打卡记录表id 考勤打卡记录表id")
    private String wsRecordId;

    @ApiModelProperty("人员账号 人员账号")
    @SaturnColumn(description = "人员账号 人员账号")
    private String userName;

    @ApiModelProperty("人员名称 人员名称")
    @SaturnColumn(description = "人员名称 人员名称")
    private String realName;

    @ApiModelProperty("职位编码 职位编码")
    @SaturnColumn(description = "职位编码 职位编码")
    private String posCode;

    @ApiModelProperty("职位名称 职位名称")
    @SaturnColumn(description = "职位名称 职位名称")
    private String posName;

    @ApiModelProperty("组织编码 组织编码")
    @SaturnColumn(description = "组织编码 组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称 组织名称")
    @SaturnColumn(description = "组织名称 组织名称")
    private String orgName;

    @ApiModelProperty("规则编码 规则编码")
    @SaturnColumn(description = "规则编码 规则编码")
    private String ruleCode;

    @ApiModelProperty("规则名称 规则名称")
    @SaturnColumn(description = "规则名称 规则名称")
    private String ruleName;

    @ApiModelProperty("规则类型 规则类型（1:固定时间上下班规则/2:自由时间上下班规则/0:自由签到）")
    @SaturnColumn(description = "规则类型 规则类型")
    private String ruleType;

    @ApiModelProperty("考勤日期 考勤日期（yyyy-MM-dd）")
    @SaturnColumn(description = "考勤日期 考勤日期")
    private String ruleDate;

    @ApiModelProperty("打卡类型 打卡类型（1:上班签到;2:下班签退）")
    @SaturnColumn(description = "打卡类型 打卡类型")
    private String workSignType;

    @ApiModelProperty("打卡类型描述 打卡类型描述")
    @SaturnColumn(description = "打卡类型描述 打卡类型描述")
    private String workSignDesc;

    @ApiModelProperty("考勤状态 考勤状态(0:未打卡;1:正常;2:迟到;3:早退;)")
    @SaturnColumn(description = "考勤状态 考勤状态")
    private String workSignStatus;

    @ApiModelProperty("考勤时间 考勤时间(HH:mm:ss)")
    @SaturnColumn(description = "考勤时间 考勤时间")
    private String workSignTime;

    @ApiModelProperty("考勤地点 考勤地点")
    @SaturnColumn(description = "考勤地点 考勤地点")
    private String workSignPlace;

    @ApiModelProperty("考勤地点状态  考勤地点状态(1:正常;2:异常;)")
    @SaturnColumn(description = "考勤地点状态 考勤地点状态")
    private String wsPlaceStatus;

    @ApiModelProperty("打卡经度 打卡经度")
    @SaturnColumn(description = "打卡经度 打卡经度")
    private String lngIn;

    @ApiModelProperty("打卡纬度 打卡纬度")
    @SaturnColumn(description = "打卡纬度 打卡纬度")
    private String latIn;

    @ApiModelProperty("考勤照片 考勤照片")
    @SaturnColumn(description = "考勤照片")
    private String picUrl;

}