package com.biz.crm.nebular.sfa.worksummary.req;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.List;
import java.util.Date;
import java.math.BigDecimal;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * 工作总结评论记录请求vo
 *
 * @author Gavin
 * @date 2021-03-06 11:00:30
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaWorkSummaryCommentReqVo", description = "工作总结评论记录")
public class SfaWorkSummaryCommentReqVo extends CrmBaseVo {

    private static final long serialVersionUID = 3671946013932594400L;
    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("工作动态ID（总结）")
    private String summaryId;

    @ApiModelProperty("评论内容")
    private String comment;

    @ApiModelProperty("被评论数据ID（工作动态ID/评论ID）")
    private String businessId;

    @ApiModelProperty("艾特人员集合")
    private List<String> atColleagueCode;
}