package com.biz.crm.nebular.sfa.worksummary.req;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.List;
import java.util.Date;
import java.math.BigDecimal;
import java.util.Set;

import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * 工作总结请求vo
 *
 * @author Gavin
 * @date 2021-03-06 11:00:30
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaWorkSummaryReqVo", description = "工作总结")
public class SfaWorkSummaryPrimaryReqVo extends CrmBaseVo {

    private static final long serialVersionUID = 7528066983324009696L;
    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("查询类型（AT_@我的/COMMENT_我评论的/SELF_自己的/POSITION_直属下级职位）")
    private String queryType;

    @ApiModelProperty("搜索")
    private String searchText;

    @ApiModelProperty("是否转发（Y/N）")
    private String isForward;

    @ApiModelProperty("转发填写内容")
    private String dynamic;

    @ApiModelProperty("转发关联工作总结Id")
    private String summaryId;

    @ApiModelProperty("工作总结")
    private String summary;

    @ApiModelProperty("工作计划")
    private String plan;

    @ApiModelProperty("类型(DAILY_日报,WEEKLY_周报,MONTHLY_月报,EXPERIENCE_心得)")
    private String lectureType;

    @ApiModelProperty("定位信息")
    private String location;

    @ApiModelProperty("权限类型（ALL_全部/SELF_SUPERIORS_自己及上级/ORG_SUBORDINATE_所在组织及下级/COLLEAGUE_自定义）")
    private String scopeType;

    @ApiModelProperty("照片json集合")
    private List<SfaWorkSummaryPictureReqVo> pictureReqVos;

    @ApiModelProperty("自定义权限人员账号")
    private List<String> scopeColleagueCode;

    @ApiModelProperty("@人员账号")
    private List<String> atColleagueCode;

    @ApiModelProperty("开始时间yyyy-MM-dd")
    private String startTime;

    @ApiModelProperty("结束时间yyyy-MM-dd")
    private String endTime;

    /**
     * 权限集合
     */
    private Set<String> scopeArray;

    /**
     * 当前登录人账号
     */
    private String currAccount;

    /**
     * 是否数据导出(Y/N)
     */
    private String isExport;
}