package com.biz.crm.nebular.sfa.worksummary.resp;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 工作总结艾特对象记录返回vo
 *
 * @author Gavin
 * @date 2021-03-06 11:00:30
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "工作总结艾特对象记录")
@SaturnEntity(name = "SfaWorkSummaryAtLogRespVo", description = "工作总结艾特对象记录")
public class SfaWorkSummaryAtLogRespVo extends CrmBaseVo {
    private static final long serialVersionUID = 8792102029148507411L;
    @ApiModelProperty("艾特人员code")
    @SaturnColumn(description = "艾特人员code")
    private String atUserCode;

    @ApiModelProperty("艾特人员名称")
    @SaturnColumn(description = "艾特人员名称")
    private String atUserName;

    @ApiModelProperty("动态ID/评论ID")
    @SaturnColumn(description = "动态ID/评论ID")
    private String businessId;

    @ApiModelProperty("工作动态（总结）ID")
    @SaturnColumn(description = "工作动态（总结）ID")
    private String summaryId;
}