package com.biz.crm.nebular.tpm.account.req;

import com.biz.crm.nebular.mdm.CrmTreeVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 费用上账总入参;请求vo
 *
 * @author zeyi
 * @date 2020-10-12 17:26:54
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TpmAccountDetailMainReqVo", description = "费用上账总入参;")
public class TpmAccountDetailMainReqVo extends CrmTreeVo {

    @ApiModelProperty("分组id(标识同一次提交的数据)")
    @SaturnColumn(description = "分组id(标识同一次提交的数据)")
    private String groupId;

    @ApiModelProperty("费用上账数据")
    private List<TpmAccountDetailReqVo> accountDetailVos;

    @ApiModelProperty("费用上账发票数据")
    private List<TpmAccountInvoiceReqVo> accountInvoiceVos;

    @ApiModelProperty("产品信息---后端保存的时候使用")
    private List<TpmAccountProductReqVo> needSaveProductList;

    @ApiModelProperty("暂存传:temp,提交传:submit")
    private String saveType;

    @ApiModelProperty("当前tpm系统名称 tpm/liqueurTpm")
    private String tpmProjectName;
}
