package com.biz.crm.nebular.tpm.act;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * @Project crm
 * @PackageName com.biz.crm.nebular.tpm.act
 * @ClassName TpmActDetailProductVo
 * @Author HuangLong
 * @Date 2021/6/9 14:06
 * @Description TODO
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "活动明细产品表vo")
@CrmColumnResolve
public class TpmActDetailProductVo extends CrmExtTenVo {

    @ApiModelProperty("活动编码")
    private String actCode;

    @ApiModelProperty("活动明细编码")
    private String actDetailCode;

    @ApiModelProperty("产品类型:ActDetailProductTypeEnum,gift赠品,normal本品,execution执行产品,replenishment货补产品")
    private String productType;

    @ApiModelProperty("产品编码")
    private String productCode;

    @ApiModelProperty("产品名称")
    private String productName;

    @ApiModelProperty("兑付方式(数据字典:payment_method,现金兑付,货品兑付)")
    private String paymentMethod;

    @ApiModelProperty("兑付方式(数据字典:payment_method,现金兑付,货品兑付)")
    private String paymentMethodDesc;

    @ApiModelProperty("全国统一价")
    private BigDecimal price;

    @ApiModelProperty("临时字段唯一值")
    private String tempUuid;
}
