package com.biz.crm.nebular.tpm.act.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author yb
 * @version 1.0
 * @date 2021/12/20 16:44
 * @description
 */
@Data
@ApiModel("活动明细报表查询返回结果对象")
public class TpmActDetailReportRespVo {

    @ApiModelProperty("活动编码")
    private String actCode;

    @ApiModelProperty("活动名称")
    private String actName;

    @ApiModelProperty("活动起始时间")
    private String beginDate;

    @ApiModelProperty("活动截止时间")
    private String endDate;

    @ApiModelProperty("活动明细编码")
    private String actDetailCode;

    @ApiModelProperty("核销明细编码")
    private String auditDetailCode;

    @ApiModelProperty("费用上账编码")
    private String accountCode;

    @ApiModelProperty("活动大类编码")
    private String categoriesCode;

    @ApiModelProperty("活动大类名称")
    private String categoriesName;

    @ApiModelProperty("关联预算科目(科目编码)")
    private String budgetSubjectsCode;

    @ApiModelProperty("关联预算科目(科目名称)")
    private String budgetSubjectsName;

    @ApiModelProperty("活动细类编码")
    private String fineCode;

    @ApiModelProperty("活动细类名称")
    private String fineName;

    @ApiModelProperty("企业组织编码")
    private String orgCode;

    @ApiModelProperty("企业组织名称")
    private String orgName;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("渠道名称")
    private String channelName;

    @ApiModelProperty("门店编码")
    private String terminalCode;

    @ApiModelProperty("门店名称")
    private String terminalName;

    @ApiModelProperty("费用申请金额")
    private BigDecimal applyAmount;

    @ApiModelProperty("支付方式名称")
    private String payTypeName;

    @ApiModelProperty("申请人账号")
    private String createCode;

    @ApiModelProperty("申请人姓名")
    private String createName;

    @ApiModelProperty("审批状态")
    private String approveStatus;

    @ApiModelProperty("活动核销状态")
    private String auditApproveStatus;

    @ApiModelProperty("核销金额")
    private String auditApplyAmount;

    @ApiModelProperty("活动申请完成时间")
    private String approveDate;

    @ApiModelProperty("活动核销完成时间")
    private String auditDate;

    @ApiModelProperty("活动上账时间")
    private String accountDate;

    @ApiModelProperty("上账状态")
    private String accountStatus;

    @ApiModelProperty("备注")
    private String remarks;


}
