package com.biz.crm.nebular.tpm.audit.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;
/**
 * 核销明细客户信息表请求vo
 *
 * @author gavin
 * @date 2021-12-20 13:49:09
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TpmAuditDetailCustomerReqVo", description = "核销明细客户信息表")
public class TpmAuditDetailCustomerReqVo extends CrmExtTenVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("核销申请明细编码")
    private String auditDetailCode;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("核销金额")
    private BigDecimal auditApplyAmount;

    @ApiModelProperty("已上账金额")
    private BigDecimal feeUsed;

    @ApiModelProperty("是否完全上账(Y/N)")
    private String isAllFeeUsed;
}