package com.biz.crm.nebular.tpm.audit.req;

import com.biz.crm.nebular.tpm.audit.resp.TpmAuditFileRespVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Project crm
 * @PackageName com.biz.crm.nebular.tpm.audit.req
 * @ClassName TpmAuditFileConvertReqVo
 * @Author HuangLong
 * @Date 2020/12/10 13:31
 * @Description 根据细类编码集合和核销文件集合转换核销申请新增页面核销资料的数据vo
 */
@Data
@ApiModel(value = "核销申请转换核销资料的请求vo")
public class TpmAuditFileConvertReqVo implements Serializable {

    private static final long serialVersionUID = -8108928649695994321L;

    @ApiModelProperty("活动细类编码集合")
    private List<String> fineCodeList;

    @ApiModelProperty("核销申请文件集合")
    private List<TpmAuditFileReqVo> auditFileReqVos;
}
