package com.biz.crm.nebular.tpm.auditcollectexample.req;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.tpm.auditcollectexample.resp.TpmAuditCollectExamplePictureRespVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Set;

import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * 核销采集示例主表 请求vo
 *
 * @author huang.long
 * @date 2020-09-09 18:20:33
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TpmAuditCollectExampleReqVo", description = "核销采集示例主表 ")
public class TpmAuditCollectExampleReqVo extends CrmExtVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("示例编码")
    private String exampleCode;

    @ApiModelProperty("示例名称")
    private String exampleName;

    @ApiModelProperty("类型(数据字典)")
    private String exampleType;

    @ApiModelProperty("排序")
    private Integer sortNum;

    @ApiModelProperty("示例照片")
    private List<TpmAuditCollectExamplePictureRespVo> pictureRespVos;

    @ApiModelProperty("回显编码，字符串，一般用于单选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这条数据")
    private String selectedCode;

    @ApiModelProperty("回显编码集合，字符串数组，一般用于多选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这些数据")
    private Set<String> selectedCodeList;

}