package com.biz.crm.nebular.tpm.costtypefine.req;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 活动采集字段表与活动细类的关联表;请求vo
 *
 * @author zeyi
 * @date 2020-11-04 13:59:17
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TpmActCollectFieldFineReqVo", description = "活动采集字段表与活动细类的关联表;")
public class TpmActCollectFieldFineReqVo extends CrmExtVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("活动采集字段编码")
    private String fieldCode;

    @ApiModelProperty("活动采集字段名称")
    private String fieldName;

    @ApiModelProperty("活动细类编码")
    private String fineCode;

    @ApiModelProperty("是否必填(Y/N)")
    private String whetherRequired;

    @ApiModelProperty("显示顺序")
    private String displayOrder;

    @ApiModelProperty("默认值")
    private String defaults;

    @ApiModelProperty("提示语")
    private String hint;

}