package com.biz.crm.nebular.tpm.invoicepool.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;
/**
 * 请求vo
 *
 * @author gavin
 * @date 2021-12-16 16:29:22
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TpmInvoicePoolReqVo", description = "发票池返回对象")
public class TpmInvoicePoolReqVo extends CrmExtTenVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("发票类型字典值")
    private String invoiceType;

    @ApiModelProperty("发票代码")
    private String invoiceCode;

    @ApiModelProperty("发票号码")
    private String invoiceNumber;

    @ApiModelProperty("开票日期")
    private String invoicingDate;

    @ApiModelProperty("校验码")
    private String checkCode;

    @ApiModelProperty("买方名称")
    private String purchaserName;

    @ApiModelProperty("买方纳税人号码")
    private String purchaserTaxpayerNumber;

    @ApiModelProperty("买方地址及电话信息")
    private String purchaserInfo;

    @ApiModelProperty("买方账户")
    private String purchaserAccount;

    @ApiModelProperty("卖方名称")
    private String sellerName;

    @ApiModelProperty("卖方纳税人号码")
    private String sellerTaxpayerNumber;

    @ApiModelProperty("卖方地址及电话信息")
    private String sellerInfo;

    @ApiModelProperty("卖方账户")
    private String sellerAccount;

    @ApiModelProperty("金额")
    private BigDecimal amount;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("税额")
    private BigDecimal taxAmount;

    @ApiModelProperty("含税总金额")
    private BigDecimal totalAmount;

    @ApiModelProperty("使用金额")
    private BigDecimal usedAmount;

    @ApiModelProperty("可用金额")
    private BigDecimal availableAmount;

}