package com.biz.crm.nebular.tpm.liqueuract.req;
import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.List;
import java.util.Date;
import java.math.BigDecimal;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * 酒类活动预算使用明细表;请求vo
 *
 * @author lf
 * @date 2021-03-10 11:35:16
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TpmLiqueurActBudgetTransactionReqVo", description = "酒类活动预算使用明细表;")
public class TpmLiqueurActBudgetTransactionReqVo extends CrmExtVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("业务编码(可能是活动申请编码,活动登记编码和核销登记编码)")
    private String businessCode;

    @ApiModelProperty("业务名称")
    private String businessName;

    @ApiModelProperty("业务明细编码(活动明细和核销明细)")
    private String businessLineCode;

    @ApiModelProperty("业务明细名称")
    private String businessLineName;

    @ApiModelProperty("业务类型(活动申请,活动明细登记,活动核销)")
    private String businessType;

    @ApiModelProperty("操作明细类型(占用,use,退回,return_back)")
    private String transactionType;

    @ApiModelProperty("操作明细类型名称")
    private String transactionTypeName;

    @ApiModelProperty("业务备注")
    private String businessRemarks;

    @ApiModelProperty("活动预算编码")
    private String actBudgetCode;

    @ApiModelProperty("费用预算控制维度id")
    private String controlId;

    @ApiModelProperty("费用预算编码")
    private String feeBudgetCode;

    @ApiModelProperty("操作金额(占用的时候为负数,退回占用的时候为正数)")
    private BigDecimal feeAmount;

    @ApiModelProperty("实际扣减顺序")
    private Integer reduceOrder;

}