package com.biz.crm.nebular.tpm.liqueuract.resp;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 活动附件信息;返回vo
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "酒类活动附件信息;")
@CrmColumnResolve
@SaturnEntity(name = "TpmLiqueurActFileRespVo", description = "酒类活动附件信息;")
public class TpmLiqueurActFileRespVo extends CrmExtVo {
    @ApiModelProperty("活动编码")
    @SaturnColumn(description = "活动编码")
    private String actCode;

    @ApiModelProperty("附件地址")
    @SaturnColumn(description = "附件地址")
    private String fileAddress;

    @ApiModelProperty("对象名称")
    @SaturnColumn(description = "对象名称")
    private String objectName;
}