package com.biz.crm.nebular.dms.rotationpic;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnDomain;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/8 17:54
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "轮播图的vo")
@SaturnEntity(name = "RotationPicVo", description = "轮播图")
@SaturnDomain(value = "rotationpic")
public class DmsRotationPicVo extends CrmExtVo {


    @ApiModelProperty(value = "图片名称")
    @SaturnColumn(description = "图片名称")
    private String name;

    @ApiModelProperty(value = "绝对路径")
    @SaturnColumn(description = "绝对路径")
    private String urlPath;

    @ApiModelProperty(value = "图片文件objectName")
    @SaturnColumn(description = "图片文件objectName")
    private String objectName;

    @ApiModelProperty(value = "完整路径")
    @SaturnColumn(description = "完整路径")
    private String fullPath;

    @ApiModelProperty(value = "图片排序")
    @SaturnColumn(description = "图片排序")
    private Integer sortNum;
}
