package com.biz.crm.nebular.mdm.availablelistrule;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @Description: 可够清单规则表主表
 * @Author: zhangyuzhu
 * @Date: 2020/9/24 16:59
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "可够清单规则表主表信息的vo")
@SaturnEntity(name = "AvailableListRuleVo", description = "可够清单规则表主表信息")
public class AvailableListRuleVo extends CrmExtVo {

    @ApiModelProperty(value = "编码")
    @SaturnColumn(description = "编码")
    private String code;

    @ApiModelProperty(value = "名称")
    @SaturnColumn(description = "名称")
    private String name;

    @ApiModelProperty(value = "规则编码(系统自动生成)")
    @SaturnColumn(description = "规则编码(系统自动生成)")
    private String ruleCode;

    @ApiModelProperty(value = "类型")
    @SaturnColumn(description = "类型")
    private Integer type;

    @ApiModelProperty(value = "维度")
    @SaturnColumn(description = "维度")
    private Integer dimension;

    /***/
    @ApiModelProperty(value = "范围信息")
    @SaturnColumn(description = "范围信息")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<AvailableListRuleAreaVo> areaes;


    /***/
    @ApiModelProperty(value = "商品信息")
    @SaturnColumn(description = "商品信息")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<AvailableListRuleGoodsVo> goods;
}
