package com.biz.crm.nebular.mdm.cusorg;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;


/**
 * @author zxw
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "客户组织树的vo")
@SaturnEntity(name = "CusOrgTreeRespVo", description = "客户组织树")
public class CusOrgTreeRespVo {

    @ApiModelProperty(value = "id")
    @SaturnColumn(description = "id")
    private String id;

    @ApiModelProperty(value = "客户组织编码")
    @SaturnColumn(description = "客户组织编码")
    private String customerOrgCode;

    @ApiModelProperty(value = "客户组织名称")
    @SaturnColumn(description = "客户组织名称")
    private String customerOrgName;

    @ApiModelProperty(value = "客户组织层级")
    @SaturnColumn(description = "客户组织层级")
    private String customerOrgLevel;

    @ApiModelProperty(value = "客户组织层级名称")
    @SaturnColumn(description = "客户组织层级名称")
    @CrmDict(typeCode = DictConstant.CUS_ORG_LEVEL,dictCodeField = "level")
    private String customerOrgLevelName;

    @ApiModelProperty(value = "客户组织类型")
    @SaturnColumn(description = "客户组织类型")
    private String customerOrgLevelType;

    @ApiModelProperty(value = "客户组织类型名称")
    @SaturnColumn(description = "客户组织类型名称")
    @CrmDict(typeCode = DictConstant.CUS_ORG_TYPE,dictCodeField = "type")
    private String customerOrgLevelTypeName;

    @ApiModelProperty(value = "客户组织描述")
    @SaturnColumn(description = "客户组织描述")
    private String customerOrgDesc;

    @ApiModelProperty(value = "上级id")
    @SaturnColumn(description = "上级id")
    private String parentId;

    @ApiModelProperty(value = "上级客户组织名称")
    @SaturnColumn(description = "上级客户组织名称")
    private String parentName;

    @ApiModelProperty(value = "下级客户组织")
    @SaturnColumn(description = "下级客户组织")
    @SaturnColumnRelation(type= SaturnColumnRelation.RelationType.OneToMany)
    private List<CusOrgTreeRespVo> children;
}
