package com.biz.crm.nebular.mdm.dict.dictattr.req;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.mdm.PageVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * @author zxw
 */
@EqualsAndHashCode(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
@Data
@Accessors(chain = true)
@ApiModel("字典属性入参")
public class MdmDictAttrReqVo extends PageVo {

    private List<String> ids;

    @ApiModelProperty("字典分类编码")
    private String dictTypeCode;
    @ApiModelProperty("属性编码")
    private String fieldCode;
    @ApiModelProperty("属性名称")
    private String fieldName;
    @ApiModelProperty("显示顺序")
    private Integer showOrder;
    @ApiModelProperty("显示模式:1显示，0：隐藏")
    private String showModel;

    private String isDefault;

}
