package com.biz.crm.nebular.mdm.dict.dictdata.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author zxw
 */
@ApiModel("字典入参")
@AllArgsConstructor
@NoArgsConstructor
@Data
@Accessors(chain = true)
public class MdmDictDataVo {

    @ApiModelProperty(value = "字典分类编码")
    private String dictTypeCode;

    @ApiModelProperty("字典行编码")
    private String dictDataCode;

    @ApiModelProperty("上级字典行编码")
    private String parentDictDataCode;

    @ApiModelProperty("排序")
    private Integer showOrder;

    @ApiModelProperty("属性集合")
    private List<MdmDictDataFieldVo> mdmDictDataFieldVos;
}
