package com.biz.crm.nebular.mdm.humanarea;

import com.biz.crm.nebular.mdm.PageVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;

/**
 * 组织-查询组织关联职位列表请求参数
 *
 * @author Tao.Chen
 * @date 2020-10-09 18:13
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmOrgPositionPageReqVo", description = "查询组织关联职位列表请求参数")
public class MdmOrgPositionPageReqVo extends PageVo {

    @ApiModelProperty("用户帐号")
    private String userAccount;

    @ApiModelProperty("用户名称")
    private String userName;

    @ApiModelProperty("职位编码")
    private String positionCode;

    @ApiModelProperty("职位名称")
    private String positionName;

    @ApiModelProperty("职位级别编码")
    private String positionLevelCode;

    @ApiModelProperty("职位级别名称")
    private String positionLevelName;

    @ApiModelProperty("上级用户帐号")
    private String parentUserAccount;

    @ApiModelProperty("上级用户名称")
    private String parentUserName;

    @ApiModelProperty("上级职位编码")
    private String parentPositionCode;

    @ApiModelProperty("上级职位名称")
    private String parentPositionName;

    @ApiModelProperty("上级组织编码")
    private String parentOrgCode;

    @ApiModelProperty("上级组织名称")
    private String parentOrgName;

    @ApiModelProperty("组织编码")
    @NotBlank(message = "组织编码不能为空")
    private String orgCode;

}
