package com.biz.crm.nebular.mdm.humanarea;

import com.biz.crm.nebular.mdm.PageVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;

/**
 * 用户-终端关联：分页请求
 *
 * @author zxw
 * @date 2020-10-15 10:21
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmUserRelationTerminalPageReqVo", description = "用户-终端关联：分页请求")
public class MdmUserRelationTerminalPageReqVo extends PageVo {

    @ApiModelProperty("终端类型")
    private String terminalType;

    @ApiModelProperty("终端名称或编码")
    private String terminalCodeOrName;

    @ApiModelProperty("查询类型(1:未关联任何用户的终端，2:未关联当前用户的终端,3:已关联任何用户的终端)")
    @NotBlank(message = "查询类型不能为空")
    private String queryType;

    @ApiModelProperty("用户帐号")
    private String userAccount;

}
