package com.biz.crm.nebular.mdm.material;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmTreeVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnDomain;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 返回vo
 *
 * @author zxw
 * @date 2020-09-01 19:55:17
 */
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "物料管理价格响应")
@Data
@SaturnDomain(value = "mdmmaterialpricerespvo")
@SaturnEntity(name = "MdmMaterialPriceRespVo", description = "物料管理价格响应")
public class MdmMaterialPriceRespVo extends CrmTreeVo {

    @ApiModelProperty("产品层级编码")
    @SaturnColumn(description = "产品层级编码")
    private String productLevelCode;

    @ApiModelProperty("物料编码")
    @SaturnColumn(description = "物料编码")
    private String materialCode;

    @ApiModelProperty("物料名称")
    @SaturnColumn(description = "物料名称")
    private String materialName;

    @ApiModelProperty("产品层级名称")
    @SaturnColumn(description = "产品层级名称")
    private String productLevelName;

    @ApiModelProperty("ai编码")
    @SaturnColumn(description = "ai编码")
    private String aiCode;

    @ApiModelProperty("条形码")
    @SaturnColumn(description = "条形码")
    private String barCode;

    @ApiModelProperty("物料类型")
    @SaturnColumn(description = "物料类型")
    private String materialType;

    @ApiModelProperty("物料类型")
    @SaturnColumn(description = "物料类型名称")
    @CrmDict(typeCode = "material_type", dictCodeField = "materialType")
    private String materialTypeName;

    @ApiModelProperty("销售公司")
    @SaturnColumn(description = "销售公司")
    private String saleCompany;

    @ApiModelProperty("销售公司")
    @SaturnColumn(description = "销售公司名称")
    @CrmDict(typeCode = "sale_company", dictCodeField = "saleCompany")
    private String saleCompanyName;

    @ApiModelProperty("规格")
    @SaturnColumn(description = "规格")
    private String specification;

    @ApiModelProperty("单位换算系数")
    @SaturnColumn(description = "单位换算系数")
    private String unitConversion;

    @ApiModelProperty("单位集合")
    @SaturnColumn(description = "单位集合")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<MdmMaterialUnitRespVo> mdmMaterialUnitRespVos;

}