package com.biz.crm.nebular.mdm.priceconditiongroup.resp;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.nebular.mdm.priceconditiongroup.req.MdmPriceConditionGroupRelFieldReqVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 条件字段分类主表 返回vo
 *
 * @author huanglong
 * @date 2020-10-14 17:21:40
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "条件字段分类主表 ")
@SaturnEntity(name = "MdmPriceConditionGroupRespVo", description = "条件字段分类主表 ")
public class MdmPriceConditionGroupRespVo extends CrmBaseVo {
    @ApiModelProperty("条件字段分类编码")
    @SaturnColumn(description = "条件字段分类编码")
    private String conditionGroupCode;

    @ApiModelProperty("条件字段分类描述")
    @SaturnColumn(description = "条件字段分类描述")
    private String conditionGroupDesc;

    @ApiModelProperty("条件编码组合key(校验编码维度不能重复用)")
    @SaturnColumn(description = "条件编码组合key(校验编码维度不能重复用)")
    private String groupCodesKey;

    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToOne)
    @SaturnColumn(description = "条件字段键值对集合")
    private List<MdmPriceConditionGroupRelFieldRespVo> conditionFieldList;
}