package com.biz.crm.nebular.mdm.pricesetting.resp;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 价格维护主表 返回vo
 *
 * @author huanglong
 * @date 2020-10-20 13:49:03
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "价格维护主表 ")
@SaturnEntity(name = "MdmPriceSettingRespVo", description = "价格维护主表 ")
public class MdmPriceSettingRespVo extends CrmBaseVo {
    @ApiModelProperty("定价记录号")
    @SaturnColumn(description = "定价记录号")
    private String priceSettingCode;

    @ApiModelProperty("条件类型编码")
    @SaturnColumn(description = "条件类型编码")
    private String conditionTypeCode;

    @ApiModelProperty("条件类型描述")
    @SaturnColumn(description = "条件类型描述")
    private String conditionTypeDesc;

    @ApiModelProperty("条件字段分类编码")
    @SaturnColumn(description = "条件字段分类编码")
    private String conditionGroupCode;

    @ApiModelProperty("条件字段分类描述")
    @SaturnColumn(description = "条件字段分类描述")
    private String conditionGroupDesc;

    @ApiModelProperty("企业组织编码")
    @SaturnColumn(description = "企业组织编码")
    private String orgCode;

    @ApiModelProperty("企业组织名称")
    @SaturnColumn(description = "企业组织名称")
    private String orgName;

    @ApiModelProperty("渠道编码")
    @SaturnColumn(description = "渠道编码")
    private String channel;

    @ApiModelProperty("渠道名称")
    @SaturnColumn(description = "渠道名称")
    private String channelName;

    @ApiModelProperty("客户编码")
    @SaturnColumn(description = "客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    @SaturnColumn(description = "客户名称")
    private String customerName;

    @ApiModelProperty("商品编码")
    @SaturnColumn(description = "商品编码")
    private String productCode;

    @ApiModelProperty("商品名称")
    @SaturnColumn(description = "商品名称")
    private String productName;

    @ApiModelProperty("价格")
    @SaturnColumn(description = "价格")
    private BigDecimal price;

    @ApiModelProperty("币种编码(字典)")
    @SaturnColumn(description = "币种编码(字典)")
    private String currencyType;

    @ApiModelProperty("商品信息")
    @SaturnColumn(description = "商品信息")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToOne)
    private MdmProductRespVo mdmProductRespVo;

    @ApiModelProperty("币种名称")
    @SaturnColumn(description = "币种名称")
    private String currencyTypeName;

    @ApiModelProperty("价格单位(字典,选项数据跟选择的商品有关)")
    @SaturnColumn(description = "价格单位(字典,选项数据跟选择的商品有关)")
    private String priceUnit;

    @ApiModelProperty("价格单位名称")
    @SaturnColumn(description = "价格单位名称")
    private String priceName;

    @ApiModelProperty("有效期开始日期")
    @SaturnColumn(description = "有效期开始日期")
    private String beginData;

    @ApiModelProperty("有效期开始时间")
    @SaturnColumn(description = "有效期开始时间")
    private String beginDataSecond;

    @ApiModelProperty("有效期结束日期")
    @SaturnColumn(description = "有效期结束日期")
    private String endData;

    @ApiModelProperty("有效期结束时间")
    @SaturnColumn(description = "有效期结束时间")
    private String endDataSecond;

    @ApiModelProperty("有效期开始日期时间")
    @SaturnColumn(description = "有效期开始日期时间")
    private LocalDateTime beginDateTime;

    @ApiModelProperty("有效期结束日期时间")
    @SaturnColumn(description = "有效期结束日期时间")
    private LocalDateTime endDateTime;

}