package com.biz.crm.nebular.mdm.terminal.resp;

import com.biz.crm.common.ParamCheck;
import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelColumn;
import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelImport;

/**
 * @author liaohua
 * @date 2020/10/15 11:13 上午
 */
@NebulaExcelImport(startRow = 1)
public class MdmTerminalContactImportExcelVo {

  /**
   * 终端编码
   */
  @NebulaExcelColumn(order = 0, title = "终端编码")
  @ParamCheck(isNotNull = true,msg = "终端编码不能为空")
  private String terminalCode;

  /**
   * 联系人姓名
   */
  @NebulaExcelColumn(order = 1, title = "联系人姓名")
  @ParamCheck(isNotNull = true,msg = "联系人姓名不能为空")
  private String contactName;

  /**
   * 联系人电话
   */
  @NebulaExcelColumn(order = 2, title = "联系人电话")
  @ParamCheck(isNotNull = true,msg = "联系人电话不能为空")
  private String contactPhone;

  public String getTerminalCode() {
    return terminalCode;
  }

  public void setTerminalCode(String terminalCode) {
    this.terminalCode = terminalCode;
  }

  public String getContactName() {
    return contactName;
  }

  public void setContactName(String contactName) {
    this.contactName = contactName;
  }

  public String getContactPhone() {
    return contactPhone;
  }

  public void setContactPhone(String contactPhone) {
    this.contactPhone = contactPhone;
  }

  @Override
  public String toString() {
    return "MdmTerminalContactImportExcelVo{" +
        "terminalCode='" + terminalCode + '\'' +
        ", contactName='" + contactName + '\'' +
        ", contactPhone='" + contactPhone + '\'' +
        '}';
  }
}
