package com.biz.crm.nebular.mdm.terminal.resp;

import com.biz.crm.common.ParamCheck;
import com.biz.crm.nebular.mdm.enums.ParamCheckTypeEnum;
import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelColumn;
import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelImport;

/**
 * @author Liao Hua
 * @date 2020/9/11 11:45 上午
 */
@NebulaExcelImport(startRow = 1)
public class MdmTerminalImportExcelVo {

    /**
     * 终端名称
     */
    @NebulaExcelColumn(order = 0, title = "终端名称")
    @ParamCheck(isNotNull = true, checkType = {ParamCheckTypeEnum.LENGTH}, msg = "终端名称不能为空", length = 64)
    private String terminalName;

    /**
     * 终端类型
     */
    @NebulaExcelColumn(order = 1, title = "终端类型")
    @ParamCheck(isNotNull = true, checkType = {ParamCheckTypeEnum.DICT}, msg = "终端类型不能为空", dictType = "terminal_type")
    private String terminalType;

    /**
     * 渠道
     */
    @NebulaExcelColumn(order = 2, title = "渠道")
    @ParamCheck(isNotNull = true, checkType = {ParamCheckTypeEnum.DICT}, msg = "渠道不能为空", dictType = "customer_source")
    private String channel;

    /**
     * 所属组织编码
     */
    @NebulaExcelColumn(order = 3, title = "所属组织编码")
    @ParamCheck(isNotNull = true, msg = "所属组织编码不能为空")
    private String orgCode;

    /**
     * 客户组织编码
     */
    @NebulaExcelColumn(order = 4, title = "客户组织编码")
    @ParamCheck(isNotNull = false, msg = "客户组织编码不能为空")
    private String customerOrgCode;

    /**
     * 省
     */
    @NebulaExcelColumn(order = 5, title = "省")
    @ParamCheck(isNotNull = true, msg = "省份不能为空")
    private String provinceName;

    /**
     * 市
     */
    @NebulaExcelColumn(order = 6, title = "市")
    @ParamCheck(isNotNull = true, msg = "市区不能为空")
    private String cityName;

    /**
     * 区
     */
    @NebulaExcelColumn(order = 7, title = "区")
    @ParamCheck(isNotNull = true, msg = "区/县不能为空")
    private String areaName;

    /**
     * 终端地址
     */
    @NebulaExcelColumn(order = 8, title = "终端地址")
    @ParamCheck(isNotNull = true, checkType = {ParamCheckTypeEnum.LENGTH}, msg = "终端地址不能为空", length = 128)
    private String terminalAddress;

    /**
     * 营业执照注册号
     */
    @NebulaExcelColumn(order = 9, title = "营业执照注册号")
    @ParamCheck(isNotNull = true, checkType = {ParamCheckTypeEnum.LENGTH}, msg = "营业执照注册号不能为空", length = 128)
    private String licenseRegisterNumber;

    /**
     * 营业执照法人姓名
     */
    @NebulaExcelColumn(order = 10, title = "营业执照法人姓名")
    @ParamCheck(isNotNull = true, checkType = {ParamCheckTypeEnum.LENGTH}, msg = "营业执照法人姓名不能为空", length = 64)
    private String licensePersonName;

    /**
     * 营业执照企业名称
     */
    @NebulaExcelColumn(order = 11, title = "营业执照企业名称")
    @ParamCheck(isNotNull = true, checkType = {ParamCheckTypeEnum.LENGTH}, msg = "营业执照企业名称不能为空", length = 128)
    private String licenseFirmName;


    public String getTerminalName() {
        return terminalName;
    }

    public void setTerminalName(String terminalName) {
        this.terminalName = terminalName;
    }

    public String getTerminalType() {
        return terminalType;
    }

    public void setTerminalType(String terminalType) {
        this.terminalType = terminalType;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getCustomerOrgCode() {
        return customerOrgCode;
    }

    public void setCustomerOrgCode(String customerOrgCode) {
        this.customerOrgCode = customerOrgCode;
    }

    public String getProvinceName() {
        return provinceName;
    }

    public void setProvinceName(String provinceName) {
        this.provinceName = provinceName;
    }

    public String getCityName() {
        return cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    public String getTerminalAddress() {
        return terminalAddress;
    }

    public void setTerminalAddress(String terminalAddress) {
        this.terminalAddress = terminalAddress;
    }

    public String getLicenseRegisterNumber() {
        return licenseRegisterNumber;
    }

    public void setLicenseRegisterNumber(String licenseRegisterNumber) {
        this.licenseRegisterNumber = licenseRegisterNumber;
    }

    public String getLicensePersonName() {
        return licensePersonName;
    }

    public void setLicensePersonName(String licensePersonName) {
        this.licensePersonName = licensePersonName;
    }

    public String getLicenseFirmName() {
        return licenseFirmName;
    }

    public void setLicenseFirmName(String licenseFirmName) {
        this.licenseFirmName = licenseFirmName;
    }

    @Override
    public String toString() {
        return "MdmTerminalImportExcelVo{" +
                "terminalName='" + terminalName + '\'' +
                ", terminalType='" + terminalType + '\'' +
                ", channel='" + channel + '\'' +
                ", orgCode='" + orgCode + '\'' +
                ", customerOrgCode='" + customerOrgCode + '\'' +
                ", provinceName='" + provinceName + '\'' +
                ", cityName='" + cityName + '\'' +
                ", areaName='" + areaName + '\'' +
                ", terminalAddress='" + terminalAddress + '\'' +
                ", licenseRegisterNumber='" + licenseRegisterNumber + '\'' +
                ", licensePersonName='" + licensePersonName + '\'' +
                ", licenseFirmName='" + licenseFirmName + '\'' +
                '}';
    }
}
