package com.biz.crm.nebular.sfa.clientsellpower.req;

import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
/**
 * 经销商/终端产品经销权范围 请求vo
 *
 * @author liuhongming
 * @date 2020-09-24 14:13:29
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaClientSellRangeReqVo", description = "经销商/终端产品经销权范围 ")
public class SfaClientSellRangeReqVo extends CrmExtVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("组织编码 组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称 组织名称")
    private String orgName;

    @ApiModelProperty("渠道编码 渠道编码")
    private String channelCode;

    @ApiModelProperty("渠道名称 渠道名称")
    private String channelName;

    @ApiModelProperty("客户编码 客户编码")
    private String clientCode;

    @ApiModelProperty("客户名称 客户名称")
    private String clientName;

    @ApiModelProperty("类型 类型(1:渠道;2:组织;3:客户)")
    private String rangeType;

    @ApiModelProperty("经销权编码 经销权编码")
    private String tspCode;

    @ApiModelProperty("经销权编码集合")
    private List<String> tspCodes;

}