package com.biz.crm.nebular.sfa.visitstep.resp;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 拜访步骤(竞品采集明细) 返回vo
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "拜访步骤(竞品采集明细) ")
@SaturnEntity(name = "SfaVisitStepColletItemRespVo", description = "拜访步骤(竞品采集明细) ")
public class SfaVisitStepColletItemRespVo extends CrmExtVo {

    @ApiModelProperty("竞品主表id")
    @SaturnColumn(description = "竞品主表id")
    private String colletId;

    @ApiModelProperty("竞品品牌")
    @SaturnColumn(description = "竞品品牌")
    private String brand;

    @ApiModelProperty("竞品产品编码")
    @SaturnColumn(description = "竞品产品编码")
    private String productCode;

    @ApiModelProperty("竞品产品名称")
    @SaturnColumn(description = "竞品产品名称")
    private String productName;

    @ApiModelProperty("铺货数量")
    @SaturnColumn(description = "铺货数量")
    private BigDecimal quantity;

    @ApiModelProperty("单位")
    @SaturnColumn(description = "单位")
    private String unit;

}