package com.biz.crm.nebular.tpm.actfieldcollect.resp;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;


/**
 * @author zeyi
 * 活动采集字段表;响应vo
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "活动采集字段表;响应vo")
@SaturnEntity(name = "TpmActCollectFieldRespVo", description = "活动采集字段表;响应vo")
public class TpmActCollectFieldRespVo extends CrmExtVo {
    @ApiModelProperty("字段编码")
    @SaturnColumn(description = "字段编码")
    private String fieldCode;

    @ApiModelProperty("字段名称")
    @SaturnColumn(description = "字段名称")
    private String fieldName;

    @ApiModelProperty("数据字典")
    @SaturnColumn(description = "数据字典")
    private String dataDict;

    @ApiModelProperty("输入类型")
    @SaturnColumn(description = "输入类型")
    private String inputType;

    @ApiModelProperty("时间格式")
    @SaturnColumn(description = "时间格式")
    private String timeFormat;

    @ApiModelProperty("字段可填大小")
    @SaturnColumn(description = "字段可填大小")
    private String fieldInputSize;

    @ApiModelProperty("显示宽度")
    @SaturnColumn(description = "显示宽度")
    private String showWidth;

    @ApiModelProperty("显示高度")
    @SaturnColumn(description = "显示高度")
    private String showHeight;

}