package com.biz.crm.nebular.tpm.advancepay.resp;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * 活动预付主表 返回vo
 *
 * @author huanglong
 * @date 2020-09-27 10:46:08
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "活动预付主表 ")
@SaturnEntity(name = "TpmActAdvancePayRespVo", description = "活动预付主表 ")
public class TpmActAdvancePayRespVo extends CrmExtVo {
    @ApiModelProperty("预付编号")
    @SaturnColumn(description = "预付编号")
    private String advanceCode;

    @ApiModelProperty("活动预付类型")
    @SaturnColumn(description = "预付活动预付类型编号")
    private String advanceType;

    @ApiModelProperty("审批状态")
    @SaturnColumn(description = "审批状态")
    private String approveStatus;

    @ApiModelProperty("审批状态名称")
    @SaturnColumn(description = "审批状态名称")
    private String approveStatusName;

    @ApiModelProperty("流程编号")
    @SaturnColumn(description = "流程编号")
    private String processCode;

    @ApiModelProperty("活动编码")
    @SaturnColumn(description = "活动编码")
    private String actCode;

    @ApiModelProperty("活动名称")
    @SaturnColumn(description = "活动名称")
    private String actName;

    @ApiModelProperty("客户编码")
    @SaturnColumn(description = "客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    @SaturnColumn(description = "客户名称")
    private String customerName;

    @ApiModelProperty("开始日期")
    @SaturnColumn(description = "开始日期")
    private String beginDate;

    @ApiModelProperty("开始时间")
    @SaturnColumn(description = "开始时间")
    private String beginDateSecond;

    @ApiModelProperty("结束日期")
    @SaturnColumn(description = "结束日期")
    private String endDate;

    @ApiModelProperty("结束时间")
    @SaturnColumn(description = "结束时间")
    private String endDateSecond;

    @ApiModelProperty("客户所属组织")
    @SaturnColumn(description = "客户所属组织")
    private String customerOrgCode;

    @ApiModelProperty("客户所属名称")
    @SaturnColumn(description = "客户所属名称")
    private String customerOrgName;

    @ApiModelProperty("申请预付总金额")
    @SaturnColumn(description = "申请预付总金额")
    private BigDecimal applyAdvanceTotalAmount;

    @ApiModelProperty("已预付总金额")
    @SaturnColumn(description = "已预付总金额")
    private BigDecimal actualAdvancePayTotalAmount;

    @ApiModelProperty("临时字段唯一值")
    @SaturnColumn(description = "临时字段唯一值")
    private String tempUuid;

    @ApiModelProperty("工作流key")
    @SaturnColumn(description = "工作流key")
    private String workFlowKey;

    @ApiModelProperty("工作流名称")
    @SaturnColumn(description = "工作流名称")
    private String workFlowName;

    @ApiModelProperty("活动预付明细")
    @SaturnColumn(description = "活动预付明细")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<TpmActAdvancePayDetailRespVo> detailVos;

}